<?php
if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly.
}

class Ultimate_AI_History_Manager
{
  public function ultimate_ai_create_new_history($user, $content, $tool_name, $history_id = 0, $post_parent = 0)
  {

    $title = $content["title"] ?? "Untitled document";
    $post_args = array(
      "post_type"     => "ultimate_ai_history",
      "post_author"  => $user->ID,
      "post_content" => "",
      "post_title"   => $title,
      "post_status"  => "publish",
      "post_parent"  => $post_parent,
      "meta_input"   => array(
        "tool_type" => $tool_name,
        "content"   => $content,
      ),
    );

    if ($history_id != 0) $post_args["ID"] = $history_id;

    $res = wp_insert_post($post_args);

    if (is_wp_error($res) || $res == 0) {
      return false;
    }


    //UPDATE THE TOOL USE META
    $user_manager = new Ultimate_AI_User_Manager();
    $user_data = $user_manager->get_full_user($user);
    $tool_uses = $user_data["meta"]["tool_uses"] ?? [];
    $tool_uses[$tool_name] = true;
    $user_manager->update_user_meta($user, ["tool_uses" => $tool_uses]);

    return $res;
  }

  public function ultimate_ai_update_history($user, $content, $history_id, $field_name = "content")
  {
    $history = get_post_meta($history_id, "content", true);
    if (!$history) return false;
    $history[$field_name] = $content;
    $post_args = array(
      "post_type"     => "ultimate_ai_history",
      "post_author"  => $user->ID,
      "post_content" => "",
      "post_status"  => "publish",
      "ID"       => $history_id,
      "meta_input"   => array(
        "content"  => $history
      ),
    );
    $res = wp_update_post($post_args);
    if (is_wp_error($res) || $res == 0) return false;
    return $res;
  }

  public function ultimate_ai_store_img_tool_urls($user, $urls, $history_id)
  {
    $history = get_post_meta($history_id, "content", true);
    if (!$history) return false;
    $history["urls"] = $urls;
    $is_success = update_post_meta($history_id, "content", $history);
    if (!$is_success) return false;
    return $history;
  }

  public function ultimate_ai_get_user_histories($user, $limit, $offset, $tool_name, $orderby, $is_only_favourite, $post_parent = 0)
  {
    if (empty($limit))  $limit = 10;

    $query_args = array(
      "post_type"     => "ultimate_ai_history",
      "post_status"    => "publish",
      "author"     => $user->ID,
      "posts_per_page" => $limit,
      "offset"     => $offset,
      "post_parent"    => $post_parent,
      "fields"      => "ids",
      "orderby"     => $orderby,
      "order"       => "DESC",
    );

    //use this if check so if some one 
    //query for only user history and dont define any tool name 
    //that means return only history that genareted by templates tool
    //exclude special tool like below ones
    if (
      $tool_name == "generate_image" ||
      $tool_name == "blog_wizard" ||
      $tool_name == "editor" ||
      $tool_name == "default_chat_tool" ||
      $tool_name == "vision_chat_tool" ||
      $tool_name == "ai_code_generator" ||
      $tool_name == "text_to_speech"
    ) {
      $query_args["meta_query"][] = ["key" => "tool_type", "value" => $tool_name, "compare" => "="];
    }

    if ($is_only_favourite) {
      $query_args["meta_query"][] = array(
        "key" => "is_favourite",
        "value" => true,
        "compare" => "="
      );
    }

    $the_query = new WP_Query($query_args);
    $histories = array();

    if ($the_query->have_posts()) {
      while ($the_query->have_posts()) {
        $the_query->the_post();
        $post_data = array();
        $post_data["data"] = get_post_meta(get_the_ID(), "content", true);
        $post_data["meta"] = get_post_meta(get_the_ID());
        $post_data["date"] = get_post_time('U', false, get_the_ID(), false);
        //remove content
        $post_data["meta"]["content"] = null;
        $post_data["history_id"] = get_the_ID();
        $histories[] = $post_data;
      }
    }

    return ["histories" => $histories, "total_post_found" => $the_query->found_posts];
  }

  public function ultimate_ai_filter_histories($query_args)
  {
    $_args = array(
      "post_type"     => "ultimate_ai_history",
      "post_status"    => "publish",
      "post_parent"    => 0, //for only parent post
    );

    $args = array_merge($_args, $query_args);


    //$post_ids = get_posts( $args ); 
    $query = new WP_Query($args);
    $histories = array();

    while ($query->have_posts()) {
      $query->the_post();
      $post_data = array();
      $post_data["data"] = get_post_meta(get_the_ID(), "content", true);
      $post_data["meta"] = get_post_meta(get_the_ID());
      //remove content
      $post_data["meta"]["content"] = null;
      $post_data["data"]["raw_document"] = wp_strip_all_tags($post_data["data"]["document"] ?? "No content");

      $post_data["meta"]["date"] = get_the_date('dS M Y');
      $post_data["meta"]["last_modified"] = get_the_modified_date('c', get_the_ID());
      $post_data["history_id"] = get_the_ID();
      $histories[] = $post_data;
    }

    return array("histories" => $histories, "total_found" => $query->found_posts);
  }

  public function get_history_by_id($user, $history_id)
  {
    //$author_id = get_post_field("post_author", $history_id);
    //check only user can access the history
    //if( !$author_id || $user->ID != (int) $author_id ) return false;
    return get_post_meta($history_id, "content", true);
  }

  public function switch_history_favourite($user, $history_id, $set_manual_value = false, $value = false)
  {
    $post_exists = (new WP_Query(["post_type" => "ultimate_ai_history", "p" => $history_id, "author" => $user->ID]))->found_posts > 0;
    if ($post_exists) {
      $prev_res = get_post_meta($history_id, "is_favourite", true);
      if ($set_manual_value) {
        $prev_res = $value;
      } else {
        $prev_res = !$prev_res;
      }
      $res = update_post_meta($history_id, "is_favourite", $prev_res);
      return $res ? true : false;
    }
    return false;
  }

  public function delete_history($user, $history_id)
  {
    $post_exists = (new WP_Query(["post_type" => "ultimate_ai_history", "p" => $history_id, "author" => $user->ID]))->found_posts > 0;
    if ($post_exists) {
      $res = wp_delete_post($history_id, true);
      return $res ? true : false;
    }
    return false;
  }

  public function update_meta($key_name, $value, $history_id, $user, $is_direcet_meta = false)
  {
    $post_exists = (new WP_Query(["post_type" => "ultimate_ai_history", "p" => $history_id, "author" => $user->ID]))->found_posts > 0;
    if ($post_exists) {
      $history = get_post_meta($history_id, "content", true);
      if (!$history) return false;
      $history[$key_name] = $value;
      $is_success = update_post_meta($history_id, "content", $history);

      if ($is_direcet_meta) {
        update_post_meta($history_id, $key_name, $value);
      }

      if ($key_name == "title") wp_update_post(["ID" => $history_id, "post_title" => $value]);
      return $is_success;
    }

    return false;
  }
}
